package com.cmes.spider.service.impl;
import com.cmes.commons.mybatis.service.AbstractCrudService;
import com.cmes.commons.mybatis.sharding.ShardTable;
import com.cmes.spider.service.FdaDataService;
import com.cmes.spider.dao.FdaDataMapper;
import com.cmes.spider.entity.FdaDataExample;
import com.cmes.spider.entity.FdaData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class FdaDataServiceImpl extends AbstractCrudService<FdaDataMapper, FdaData, FdaDataExample, Integer>
        implements FdaDataService {

    @Autowired
    private FdaDataMapper fdaDataMapper;

    @Override
    public int batchInsertIgnore(List<FdaData> records) {
        return fdaDataMapper.batchInsertIgnore(records);
    }

    @Override
    protected FdaDataExample getPageExample(final String fieldName, final String keyword) {
        final FdaDataExample example = new FdaDataExample();
        example.createCriteria().andFieldLike(fieldName, keyword);
        return example;


    }

}
