package com.cmes.spider.engine;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.IOException;

public class JsoupEngine {
    private String url;
    private Document document;

    public JsoupEngine(String url) throws IOException {
        this.url = url;
        this.document = Jsoup.connect(url).get();

    }

    public Elements select(String ele) {
        return document.select(ele);
    }

    public String getTitle() {
        return document.title();
    }

    public String getUrl() {
        return this.url;
    }

}
