package com.cmes.spider;

import com.cmes.spider.engine.FdaJob;
import com.cmes.spider.engine.JsoupEngine;
import com.cmes.spider.entity.FdaData;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

import java.io.IOException;
import java.util.Set;

@SpringBootApplication(scanBasePackages = {"com.cmes.spider"})
@Slf4j
public class WalletJobApplication {
    @Autowired
    FdaJob fdaJob;

    public static void main(String[] args) {
        SpringApplication.run(WalletJobApplication.class, args);
    }

    @Bean
    public ApplicationRunner applicationRunner() {

        return new ApplicationRunner() {
            public void run(final ApplicationArguments args) throws Exception {

                fdaJob.run();
            }
        };
    }

}
