package com.blocksignature.utils;

import com.blocksignature.signature.GenerateAddressUtil;
import com.blocksignature.signature.SignatureTransactionUtil;
import com.blocksignature.signature.UnsignedMessageAPI;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;

public class FilecoinUtil {
    public String generateAddress(ECKey ecKey) {
        return GenerateAddressUtil.generateAddress(ecKey);
    }

    public String signatureTransaction(UnsignedMessageAPI message, ECKey ecKey) {
        String hexKey = Utils.HEX.encode(ecKey.getPrivKeyBytes());
        return SignatureTransactionUtil.transaction_serialize(message, hexKey);
    }
}
