package com.blocksignature.signature;

import org.bitcoinj.core.ECKey;

public class GenerateAddressUtil {
    private static final String per = "f1";

    public static String generateAddress(ECKey publicECKey) {
        String pulStr = "0x04" + publicECKey.getPubKeyPoint().getAffineXCoord().toString() + publicECKey.getPubKeyPoint().getAffineYCoord().toString();
        byte[] bytes =
                NumericUtil.hexToBytes(pulStr);
        Blake2b.Param p = new Blake2b.Param();
        p.setDigestLength(20);
        Blake2b blake2Hash = Blake2b.Digest.newInstance(p);
        byte[] black2HashByte = blake2Hash.digest(bytes);
        String black2HashStr = NumericUtil.bytesToHex(black2HashByte);
        String black2HashSecond = "0x01" + black2HashStr;

        p.setDigestLength(4);
        Blake2b.Digest blake2b2 = Blake2b.Digest.newInstance(p);
        byte[] checksumBytes = blake2b2.digest(NumericUtil.hexToBytes(black2HashSecond));

        byte[] addressBytes = new byte[black2HashByte.length + checksumBytes.length];
        System.arraycopy(black2HashByte, 0, addressBytes, 0, black2HashByte.length);
        System.arraycopy(checksumBytes, 0, addressBytes, black2HashByte.length, checksumBytes.length);
        String address = Base32.encode(addressBytes);

        return per + address;
    }
}
