package main

import "C"
import (
	"encoding/json"
	"keys/bean"
	keys "keys/coinutils"
	"keys/filutils"
	"strconv"
	"strings"
)

//export GenerateFilAddress
func GenerateFilAddress(pub string) *C.char {
	addr, _ := keys.FilecoinAddressByPubKey(pub)
	return C.CString(addr)
}

//export FilecoinSignRawTx
func FilecoinSignRawTx(wifPriKey string, nonce string, toAccount string, value string, gasPrice string, gaslimit string) *C.char {
	nonce64, _ := strconv.ParseUint(nonce, 0, 64)
	value64, _ := strconv.ParseUint(value, 0, 64)
	gasPrice64, _ := strconv.ParseUint(gasPrice, 0, 64)
	gaslimit64, _ := strconv.ParseUint(gaslimit, 0, 64)
	signedtx, hextx, txid, _ := keys.FilecoinSignRawTx(wifPriKey, nonce64, toAccount, value64, gasPrice64, gaslimit64)
	replace := strings.Replace(signedtx, "\n", "", -1)
	result := filutils.SignedMessage{}
	json.Unmarshal([]byte(replace), &result)
	signInfo := bean.SignatureInfo{
		TxId:     txid,
		HexTx:    hextx,
		SignedTx: result,
	}
	jsonStr, _ := json.Marshal(signInfo)
	return C.string(jsonStr)
}

func main() {
}
