package main

import "C"
import (
	"encoding/json"
	"keys/bean"
	keys "keys/coinutils"
	"keys/filutils"
	"strconv"
	"strings"
)

//export GenerateFilAddress
func GenerateFilAddress(pub string) *C.char {
	addr, _ := keys.FilecoinAddressByPubKey(pub)
	return C.CString(addr)
}

//export FilecoinSignRawTx
func FilecoinSignRawTx(wifPriKey string, nonce string, toAccount string, value string, gasPremium string, gasFeeCap string, gasLimit string) *C.char {
	nonce64, _ := strconv.ParseUint(nonce, 0, 64)
	value64, _ := strconv.ParseUint(value, 0, 64)
	gasPremium64, _ := strconv.ParseUint(gasPremium, 0, 64)
	gasFeeCap64, _ := strconv.ParseUint(gasFeeCap, 0, 64)
	gasLimit64, _ := strconv.ParseUint(gasLimit, 0, 64)
	signedtx, hextx, txid, _ := keys.FilecoinSignRawTx(wifPriKey, nonce64, toAccount, value64, gasPremium64, gasFeeCap64, gasLimit64)
	replace := strings.Replace(signedtx, "\n", "", -1)
	result := filutils.SignedMessage{}
	json.Unmarshal([]byte(replace), &result)
	signInfo := bean.SignatureInfo{
		TxId:     txid,
		HexTx:    hextx,
		SignedTx: result,
	}
	jsonStr, _ := json.Marshal(signInfo)
	return C.CString(string(jsonStr))
}

func main() {
}
