package keys

import (
	"encoding/base64"
	"github.com/btcsuite/btcd/btcec"
	"github.com/btcsuite/btcd/chaincfg"
	"github.com/btcsuite/btcutil"
	"keys/filutils"
)

func FilecoinAddressByPubKeyBytes(pubBytes []byte) (addr string, err error) {
	//pk ,_ := base.Encode(base.Base58BTC,pubBytes)
	pub, _ := btcec.ParsePubKey(pubBytes, btcec.S256())
	var address filutils.Address
	address, err = filutils.NewSecp256k1Address(pub.SerializeUncompressed())
	addrEncode, _ := filutils.Encode(filutils.Mainnet, address)
	return addrEncode, nil
}

// BitcoinAddress func
func BitcoinAddress(pubKeyBase64 string) (addr string, err error) {
	base64er := base64.RawStdEncoding
	decoder_buf, _ := base64er.DecodeString(pubKeyBase64)
	pk, _ := btcec.ParsePubKey(decoder_buf, btcec.S256())
	var params *chaincfg.Params
	params = &chaincfg.MainNetParams
	pkadr, err := btcutil.NewAddressPubKey(pk.SerializeCompressed(), params)
	if err != nil {
		return
	}
	pkh := pkadr.AddressPubKeyHash()
	addr = pkh.EncodeAddress()

	return addr, nil
}
